/*---------------------------------------------------------------------------*/
/* TRIGGER EM DOCREC                                                         */
/*---------------------------------------------------------------------------*/
if exists (select * from sysobjects where id = object_id('Docrec_InsUpd_Emp'))
   drop trigger [Docrec_InsUpd_Emp]
GO

CREATE TRIGGER [Docrec_InsUpd_Emp] ON [Docrec]
FOR INSERT,UPDATE
AS
DECLARE @Msg varchar(256),
        @Numint varchar(20),
        @Coddoc varchar(10),
        @Numdoc varchar(10),
        @Serdoc varchar(10)


BEGIN
SET ANSI_NULLS ON
SET NOCOUNT ON

/*----------------------------------------------*/
/* VERIFICA DUPLICIDADE DE CODDOC,NUMDOC,SERDOC */
/*----------------------------------------------*/

select top 1 @Numint=docrec.Numint,@Coddoc=i.coddoc,@Numdoc=i.numdoc,@Serdoc=coalesce(i.serdoc,'')
from
inserted i inner join docrec on
((i.coddoc=docrec.coddoc and i.tipo<>'Nota de Servio') or (i.coddoc=docrec.coddoc and i.tipo='Nota de Servio' and datediff(year,i.dataemi,docrec.dataemi) <> 0)) and /* S verifica se coddoc for preenchido. Se for nota de servio s verifica se for o mesmo ano*/
i.numdoc=docrec.numdoc and /* S verifica se numdoc for preenchido*/
(i.serdoc=docrec.serdoc or (i.serdoc is null and docrec.serdoc is null))

where
i.numint<>docrec.numint

if @Numint is not null
   BEGIN
   set @Msg = 'Documento ' + @Coddoc + @Numdoc + @Serdoc + ' j est registrado como nmero interno ' + @Numint
   raiserror( @Msg, 11, 1 )
   ROLLBACK TRANSACTION
   return
   END
/*----------------------------------------------------*/
/* FIM - VERIFICA DUPLICIDADE DE CODDOC,NUMDOC,SERDOC */
/*----------------------------------------------------*/

END
GO

/*---------------------------------------------------------------------------*/
/* FIM  DA TRIGGER EM DOCREC                                                 */
/*---------------------------------------------------------------------------*/
